<?php
/**
 *  Plugin Content - iCagenda :: JComments
 *----------------------------------------------------------------------------
 * @package     com_icagenda
 * @copyright   Copyright (c)2012-2016 Cyril Rezé, Jooml!C - All rights reserved

 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 * @author      Cyril Rezé (Lyr!C)
 * @link        http://www.joomlic.com
 *
 * @version     1.1.0 2016-09-15
 * @since       1.0.0
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *----------------------------------------------------------------------------
*/

// No direct access to this file
defined('_JEXEC') or die();

jimport('joomla.plugin.plugin');

/**
 * plgContentiC_jcomments
 */
class plgContentiC_jcomments extends JPlugin
{
	/**
	 * Plugin that integrates jComments in iCagenda events.
	 *
	 * @param   string   $context  The context of the content being passed to the plugin.
	 * @param   mixed    &$item    An object with a "text" property.
	 * @param   mixed    &$params  Additional parameters.
	 *
	 * @return  boolean            True on success.
	 *
	 * @since   1.1.0
	 */
	public function onEventPrepare($context, &$item, &$params)
	{
		if ($context == 'com_icagenda.event')
		{
			$item->jcomments = self::isDisabled($item, true) ? false : true;

			self::clear($item);
		}
	}

	/**
	 * Load Comments Count for each event in main List of Events view.
	 *
	 * @param   string   $context  The context of the content being passed to the plugin.
	 * @param   mixed    &$item    An object with a "text" property.
	 * @param   mixed    &$params  Additional parameters.
	 *
	 * @return  html               Comments counter.
	 *
	 * @since   1.0.0
	 */
	public function onListAddEventInfo($context, &$item, &$params)
	{
		// Exclude admin and not authorized
		$app = JFactory::getApplication ();
		$input = JFactory::getApplication()->input;

		$iclist_show_count = $this->params->get('iclist_show_count', 1);

		if ($input->getCmd('option') === 'com_icagenda'
			&& $iclist_show_count
			&& $app->isSite())
		{
			$comments = JPATH_ROOT . '/components/com_jcomments/jcomments.php';

			if (file_exists($comments))
			{
				require_once($comments);

				// Test if translation is missing, set to en-GB by default
				$language = JFactory::getLanguage();
				$language->load('plg_content_ic_jcomments', JPATH_ADMINISTRATOR, 'en-GB', true);
				$language->load('plg_content_ic_jcomments', JPATH_ADMINISTRATOR, null, true);

				$count = JComments::getCommentsCount($item->id, 'com_icagenda');
				$comments_string = '<div class="ic-jcomments">' . JText::sprintf('PLG_CONTENT_IC_JCOMMENTS_COMMENTS_COUNT', $count) . '</div>';

				$jcomments_count = $count ? $comments_string : false;
			}

			return $jcomments_count;
		}

		return false;
	}

	/**
	 * Load jcomments after event details view.
	 *
	 * @param   string   $context  The context of the content being passed to the plugin.
	 * @param   mixed    &$item    An object with a "text" property.
	 * @param   mixed    &$params  Additional parameters.
	 *
	 * @return  html               Show Comments.
	 *
	 * @since   1.0.0
	 */
	public function onEventAfterDisplay($context, &$item, &$params)
	{
		// Exclude admin and not authorized
		$app = JFactory::getApplication ();
		$input = JFactory::getApplication()->input;

		$enabled = isset($item->jcomments) ? $item->jcomments : true;

		if ($input->getCmd('option') === 'com_icagenda'
			&& $app->isSite())
		{
			$comments = JPATH_ROOT . '/components/com_jcomments/jcomments.php';

			if (file_exists($comments) && $enabled)
			{
				require_once($comments);

				echo JComments::showComments($item->id, 'com_icagenda', $item->title);
			}

			return true;
		}

		return false;
	}

	/**
	 *
	 * @param   object   $item          The content item object
	 * @param   array    $patterns
	 * @param   array    $replacements
	 *
	 * @return  void
	 *
	 * @since   1.1.0
	 */
	protected static function _processTags(&$item, $patterns = array(), $replacements = array())
	{
		if (count($patterns) > 0)
		{
			ob_start();

			if (isset($item->desc))
			{
				$item->desc = preg_replace($patterns, $replacements, $item->desc);
			}

			ob_end_clean();
		}
	}

	/**
	 * Clears all JComments tags from content item
	 *
	 * @param   object   $item     Content object
	 *
	 * @return  void
	 *
	 * @since   1.1.0
	 */
	public static function clear(&$item)
	{
		$patterns     = array('/{jcomments\s+(off|on|lock)}/is');
		$replacements = array('');

		self::_processTags($item, $patterns, $replacements);
	}

	/**
	 * Searches given tag in content object
	 *
	 * @param   object   $row      The content item object
	 * @param   string   $pattern
	 *
	 * @return  boolean            True if any tag found, False otherwise
	 *
	 * @since   1.1.0
	 */
	protected static function _findTag(&$item, $pattern)
	{
		return (isset($item->desc) && preg_match($pattern, $item->desc));
	}

	/**
	 * Return true if one of text fields contains {jcomments off} tag
	 *
	 * @param   object   $row      Content object
	 *
	 * @return  boolean            True if {jcomments off} found, False otherwise
	 *
	 * @since   1.1.0
	 */
	public static function isDisabled(&$item)
	{
		return self::_findTag($item, '/{jcomments\s+off}/is');
	}
}
