<?php
/**
 * Language Package Installation Script
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class pkg_iCagenda_caESInstallerScript
{
	public function install(InstallerAdapter $parent): bool
	{
		return true;
	}

	public function update(InstallerAdapter $parent): bool
	{
		return true;
	}

	public function uninstall(InstallerAdapter $parent): bool
	{
		return true;
	}

	public function preflight(string $type, InstallerAdapter $parent): bool
	{
		return true;
	}

	public function postflight(string $type, InstallerAdapter $parent): bool
	{
		$this->maintenancePackage($parent);

		return true;
	}

	/*
		* Maintenance language package.
		*/
	private function maintenancePackage(InstallerAdapter $parent)
	{
		$this->deleteUnexistingFiles();

		$updateServerChanged = true;

		if ($updateServerChanged) {
			$element = $parent->getManifest()->element;

			// Get current package extension_id
			$db    = Factory::getDbo();
			$query = $db->getQuery(true)
				->select('extension_id')
				->from($db->qn('#__extensions'))
				->where($db->qn('element') . ' = ' . $db->q($element));
			$db->setQuery($query);

			$eid = $db->loadResult();

			$this->removeObsoleteUpdateSite($eid);
		}

		$extElementChanged = 1;

		if ($extElementChanged) {
			$deprecated_elements = ["iCagenda_pkg_ca-ES"];

			if ($deprecated_elements) {
				foreach ($deprecated_elements as $el) {
					if ($el) {
						$db    = Factory::getDbo();
						$query = $db->getQuery(true)
							->select('extension_id')
							->from($db->qn('#__extensions'))
							->where($db->qn('element') . ' = ' . $db->q($el));
						$db->setQuery($query);

						$oldid = $db->loadResult();

						$this->removeObsoleteUpdateSite($oldid);
						$this->deleteObsoleteExtension($oldid);
					}
				}
			}
		}

		return true;
	}

	private function deleteUnexistingFiles()
	{
		$files = [];  // overwrite this line with your files to delete

		if (empty($files)) {
			return;
		}

		foreach ($files as $file) {
			try {
				File::delete(JPATH_ROOT . '/' . ltrim('/', $file));
			} catch (\FilesystemException $e) {
				echo Text::sprintf('FILES_JOOMLA_ERROR_FILE_FOLDER', $file) . '<br>';
			}
		}
	}

	/*
		* Delete obsolete extension.
		*/
	private function deleteObsoleteExtension($eid)
	{
		if ($eid) {
			$db    = Factory::getDbo();
			$query = $db->getQuery(true)
				->delete('#__extensions')
				->where('extension_id = ' . (int) $eid);
			$db->setQuery($query);
			$db->execute();
		}
	}

	/*
		* Remove unused update site.
		*/
	private function removeObsoleteUpdateSite($eid)
	{
		if ($eid) {
			$db    = Factory::getDbo();
			$query = $db->getQuery(true)
				->delete('#__update_sites_extensions')
				->where('extension_id = ' . (int) $eid);
			$db->setQuery($query);
			$db->execute();

			// Delete any unused update sites
			$query->clear()
				->select('update_site_id')
				->from('#__update_sites_extensions');
			$db->setQuery($query);
			$results = $db->loadColumn();

			if (\is_array($results)) {
				// So we need to delete the update sites and their associated updates
				$updatesite_delete = $db->getQuery(true);
				$updatesite_delete->delete('#__update_sites');
				$updatesite_query = $db->getQuery(true);
				$updatesite_query->select('update_site_id')
					->from('#__update_sites');

				// If we get results back then we can exclude them
				if (\count($results)) {
					$updatesite_query->where('update_site_id NOT IN (' . implode(',', $results) . ')');
					$updatesite_delete->where('update_site_id NOT IN (' . implode(',', $results) . ')');
				}

				// So let's find what update sites we're about to nuke and remove their associated extensions
				$db->setQuery($updatesite_query);
				$update_sites_pending_delete = $db->loadColumn();

				if (\is_array($update_sites_pending_delete) && \count($update_sites_pending_delete)) {
					// Nuke any pending updates with this site before we delete it
					// TODO: investigate alternative of using a query after the delete below with a query and not in like above
					$query->clear()
						->delete('#__updates')
						->where('update_site_id IN (' . implode(',', $update_sites_pending_delete) . ')');
					$db->setQuery($query);
					$db->execute();
				}

				// Note: this might wipe out the entire table if there are no extensions linked
				$db->setQuery($updatesite_delete);
				$db->execute();
			}

			// Last but not least we wipe out any pending updates for the extension
			$query->clear()
				->delete('#__updates')
				->where('extension_id = ' . $eid);
			$db->setQuery($query);
			$db->execute();
		}
	}
}
