<?php
/**
 *	Plugin Content - iCagenda :: JComments
 *----------------------------------------------------------------------------
 * @package     com_icagenda
 * @copyright   Copyright (c)2012-2015 Cyril Rezé, Jooml!C - All rights reserved

 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 * @author      Cyril Rezé (Lyr!C)
 * @link        http://www.joomlic.com
 *
 * @version		1.0.0 2015-04-24
 * @since		1.0.0
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *----------------------------------------------------------------------------
*/

// No direct access to this file
defined('_JEXEC') or die();

jimport('joomla.plugin.plugin');

/**
 * plgContentiC_jcomments
 */
class plgContentiC_jcomments extends JPlugin
{
	/**
	 * Load Comments Count for each event in main List of Events view.
	 *
	 * @since 1.0.0
	 */
	public function onListAddEventInfo($context, &$item, &$params)
	{
		// Exclude admin and not authorized
		$app = JFactory::getApplication ();
		$input = JFactory::getApplication()->input;

		$iclist_show_count = $this->params->get('iclist_show_count', 1);

		if ($input->getCmd('option') === 'com_icagenda'
			&& $iclist_show_count
			&& $app->isSite())
		{
			$comments = JPATH_ROOT . '/components/com_jcomments/jcomments.php';

			if (file_exists($comments))
			{
				require_once($comments);

				// Test if translation is missing, set to en-GB by default
				$language = JFactory::getLanguage();
				$language->load('plg_content_ic_jcomments', JPATH_ADMINISTRATOR, 'en-GB', true);
				$language->load('plg_content_ic_jcomments', JPATH_ADMINISTRATOR, null, true);

				$count = JComments::getCommentsCount($item->id, 'com_icagenda');
				$comments_string = '<div class="ic-jcomments">' . JText::sprintf('PLG_CONTENT_IC_JCOMMENTS_COMMENTS_COUNT', $count) . '</div>';

				$jcomments_count = $count ? $comments_string : false;
			}

			return $jcomments_count;
		}

		return false;
	}

	/**
	 * Load jcomments after event details view.
	 *
	 * @since 1.0.0
	 */
	public function onEventAfterDisplay($context, &$item, &$params)
	{
		// Exclude admin and not authorized
		$app = JFactory::getApplication ();
		$input = JFactory::getApplication()->input;

		if ($input->getCmd('option') === 'com_icagenda'
			&& $app->isSite())
		{
			$comments = JPATH_ROOT . '/components/com_jcomments/jcomments.php';

			if (file_exists($comments))
			{
				require_once($comments);

				echo JComments::showComments($item->id, 'com_icagenda', $item->title);
			}

			return true;
		}

		return false;
	}
}
